local inner = math.sin(math.pi * 1/10) / math.sin(math.pi * 3/10)
local unitPath = Path.point{
    x = 0,
    y = 1,
}:addLine{
    x = inner * math.cos(math.pi * 3/10),
    y = inner * math.sin(math.pi * 3/10),
}:addLine{
    x = math.cos(math.pi * 1/10),
    y = math.sin(math.pi * 1/10),
}:addLine{
    x = inner * math.cos(math.pi * 19/10),
    y = inner * math.sin(math.pi * 19/10),
}:addLine{
    x = math.cos(math.pi * 17/10),
    y = math.sin(math.pi * 17/10),
}:addLine{
    x = inner * math.cos(math.pi * 15/10),
    y = inner * math.sin(math.pi * 15/10),
}:addLine{
    x = math.cos(math.pi * 13/10),
    y = math.sin(math.pi * 13/10),
}:addLine{
    x = inner * math.cos(math.pi * 11/10),
    y = inner * math.sin(math.pi * 11/10),
}:addLine{
    x = math.cos(math.pi * 9/10),
    y = math.sin(math.pi * 9/10),
}:addLine{
    x = inner * math.cos(math.pi * 7/10),
    y = inner * math.sin(math.pi * 7/10),
}:closeSubpath()
local unitArea = 5 * math.sin(math.pi * 1/10) / math.tan(math.pi * 3/10)
local sizeRatio = math.sqrt(4 / unitArea)

StarPointStamp = function(canvas, x, y, radius, paint)
    local size = (radius or 2) * sizeRatio
    local transformation = Transformation.identity():translate(x, y):scale(size)
    canvas:preserve(function(canvas)
        canvas:concatTransformation(transformation)
            :setPaint(paint)
            :fill(unitPath)
    end)
end

return StarPointStamp
